/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.trans;

import EDU.purdue.cs.bloat.editor.IncOperand;
import EDU.purdue.cs.bloat.editor.Instruction;
import EDU.purdue.cs.bloat.editor.Label;
import EDU.purdue.cs.bloat.editor.LocalVariable;
import EDU.purdue.cs.bloat.editor.MemberRef;
import EDU.purdue.cs.bloat.editor.MethodEditor;
import EDU.purdue.cs.bloat.editor.NameAndType;
import EDU.purdue.cs.bloat.editor.Opcode;
import EDU.purdue.cs.bloat.editor.Type;
import EDU.purdue.cs.bloat.trans.ArrayList2;
import java.util.ArrayList;
import java.util.Iterator;

public class CompactArrayInitializer
implements Opcode {
    public static boolean DEBUG = false;
    private static final MemberRef GET_CHARS;
    private static final int EXPECT_SIZE = 0;
    private static final int EXPECT_NEW = 1;
    private static final int EXPECT_DUP = 2;
    private static final int EXPECT_INDEX_OR_SIZE = 3;
    private static final int EXPECT_VALUE_OR_SIZE_OR_NEW = 4;
    private static final int EXPECT_STORE_OR_NEW = 5;
    private static final int EXPECT_PUT_OR_DUP = 6;
    private static final int THRESHOLD = 16;
    private static final String[] STATES;

    static {
        STATES = new String[]{"EXPECT_SIZE", "EXPECT_NEW", "EXPECT_DUP", "EXPECT_INDEX_OR_SIZE", "EXPECT_VALUE_OR_SIZE_OR_NEW", "EXPECT_STORE_OR_NEW", "EXPECT_PUT_OR_DUP"};
        GET_CHARS = new MemberRef(Type.STRING, new NameAndType("getChars", Type.getType("(II[CI)V")));
    }

    public static boolean transform(MethodEditor method) {
        if (DEBUG) {
            System.out.println("Compacting array initializer in " + method);
        }
        boolean filled = false;
        int state = 0;
        int size = 0;
        int value = 0;
        int index = 0;
        int[] data = null;
        Type elementType = null;
        ArrayList2 buf = new ArrayList2(method.code().size());
        Iterator iter = method.code().iterator();
        while (iter.hasNext()) {
            Object ce;
            block66: {
                block65: {
                    ce = iter.next();
                    if (DEBUG) {
                        System.out.println("Examining " + ce);
                        System.out.println("state = " + STATES[state]);
                    }
                    if (!(ce instanceof Instruction)) break block65;
                    Instruction inst = (Instruction)ce;
                    block0 : switch (state) {
                        case 0: {
                            switch (inst.opcodeClass()) {
                                case 18: {
                                    if (inst.operand() instanceof Byte || inst.operand() instanceof Short || inst.operand() instanceof Integer) {
                                        size = ((Number)inst.operand()).intValue();
                                        state = 1;
                                        break;
                                    }
                                    break block66;
                                }
                                default: {
                                    state = 0;
                                    break;
                                }
                            }
                            break block66;
                        }
                        case 1: {
                            switch (inst.opcodeClass()) {
                                case 188: {
                                    elementType = (Type)inst.operand();
                                    if (elementType.isIntegral()) {
                                        data = new int[size];
                                        state = 2;
                                        break block0;
                                    }
                                    state = 0;
                                    break block0;
                                }
                                case 18: {
                                    if (inst.operand() instanceof Byte || inst.operand() instanceof Short || inst.operand() instanceof Integer) {
                                        size = ((Number)inst.operand()).intValue();
                                        state = 1;
                                        break block0;
                                    }
                                    state = 0;
                                    break block0;
                                }
                            }
                            state = 0;
                            break;
                        }
                        case 2: {
                            switch (inst.opcodeClass()) {
                                case 89: {
                                    state = 3;
                                    break block0;
                                }
                                case 18: {
                                    if (inst.operand() instanceof Byte || inst.operand() instanceof Short || inst.operand() instanceof Integer) {
                                        size = ((Number)inst.operand()).intValue();
                                        state = 1;
                                        break block0;
                                    }
                                    state = 0;
                                    break block0;
                                }
                            }
                            state = 0;
                            break;
                        }
                        case 3: {
                            switch (inst.opcodeClass()) {
                                case 18: {
                                    if (inst.operand() instanceof Byte || inst.operand() instanceof Short || inst.operand() instanceof Integer) {
                                        index = ((Number)inst.operand()).intValue();
                                        if (index < data.length) {
                                            state = 4;
                                            break block0;
                                        }
                                        size = index;
                                        state = 1;
                                        break block0;
                                    }
                                    state = 0;
                                    break block0;
                                }
                            }
                            state = 0;
                            break;
                        }
                        case 4: {
                            switch (inst.opcodeClass()) {
                                case 18: {
                                    if (inst.operand() instanceof Byte || inst.operand() instanceof Short || inst.operand() instanceof Integer) {
                                        value = ((Number)inst.operand()).intValue();
                                        state = 5;
                                        break block0;
                                    }
                                    if (inst.operand() instanceof Character) {
                                        Character ch = (Character)inst.operand();
                                        value = ch.charValue();
                                        state = 5;
                                        break block0;
                                    }
                                    state = 0;
                                    break block0;
                                }
                                case 188: {
                                    size = index;
                                    elementType = (Type)inst.operand();
                                    if (elementType.isIntegral()) {
                                        data = new int[size];
                                        state = 2;
                                        break block0;
                                    }
                                    state = 0;
                                    break block0;
                                }
                            }
                            state = 0;
                            break;
                        }
                        case 5: {
                            switch (inst.opcodeClass()) {
                                case 84: {
                                    if (elementType.equals(Type.BYTE) || elementType.equals(Type.BOOLEAN)) {
                                        data[index] = value;
                                        state = 6;
                                        break;
                                    }
                                    break block66;
                                }
                                case 85: {
                                    if (elementType.equals(Type.CHARACTER)) {
                                        data[index] = value;
                                        state = 6;
                                        break;
                                    }
                                    break block66;
                                }
                                case 86: {
                                    if (elementType.equals(Type.SHORT)) {
                                        data[index] = value;
                                        state = 6;
                                        break;
                                    }
                                    break block66;
                                }
                                case 79: {
                                    if (elementType.equals(Type.INTEGER)) {
                                        data[index] = value;
                                        state = 6;
                                        break;
                                    }
                                    break block66;
                                }
                                case 18: {
                                    if (inst.operand() instanceof Byte || inst.operand() instanceof Short || inst.operand() instanceof Integer) {
                                        size = ((Number)inst.operand()).intValue();
                                        state = 1;
                                        break;
                                    }
                                    state = 0;
                                    break;
                                }
                                case 188: {
                                    size = value;
                                    elementType = (Type)inst.operand();
                                    if (elementType.isIntegral()) {
                                        data = new int[size];
                                        state = 2;
                                        break;
                                    }
                                    state = 0;
                                    break;
                                }
                                default: {
                                    state = 0;
                                    break;
                                }
                            }
                            break block66;
                        }
                        case 6: {
                            switch (inst.opcodeClass()) {
                                case 89: {
                                    state = 3;
                                    break block0;
                                }
                                case 18: {
                                    if (inst.operand() instanceof Byte || inst.operand() instanceof Short || inst.operand() instanceof Integer) {
                                        size = ((Number)inst.operand()).intValue();
                                        state = 1;
                                        break block0;
                                    }
                                    state = 0;
                                    break block0;
                                }
                                case 58: 
                                case 83: 
                                case 179: 
                                case 181: 
                                case 204: 
                                case 205: {
                                    if (data.length >= 16) {
                                        CompactArrayInitializer.fillArray(method, buf, elementType, data);
                                        filled = true;
                                    }
                                    state = 0;
                                    break block0;
                                }
                            }
                            state = 0;
                        }
                    }
                    break block66;
                }
                Label label = (Label)ce;
                if (label.startsBlock()) {
                    state = 0;
                }
            }
            if (DEBUG) {
                System.out.println("     -> " + STATES[state]);
            }
            buf.add(ce);
        }
        if (filled) {
            method.code().clear();
            method.code().addAll(buf);
            if (DEBUG) {
                int i = 0;
                while (i < method.code().size()) {
                    System.out.println("code[" + i + "] " + method.code().get(i));
                    ++i;
                }
            }
        }
        return filled;
    }

    private static void fillArray(MethodEditor m, ArrayList2 buf, Type elementType, int[] data) {
        LocalVariable array;
        int i;
        int j;
        int i2;
        char[] c;
        if (elementType.equals(Type.CHARACTER)) {
            c = new char[data.length];
            i2 = 0;
            while (i2 < data.length) {
                c[i2] = (char)data[i2];
                ++i2;
            }
        } else if (elementType.equals(Type.BYTE) || elementType.equals(Type.BOOLEAN)) {
            c = new char[(data.length + 1) / 2];
            j = 0;
            i = 0;
            while (i + 1 < data.length) {
                c[j++] = (char)(data[i] << 8 | data[i + 1] & 0xFF);
                i += 2;
            }
            if (j != c.length) {
                c[j++] = (char)(data[data.length - 1] << 8);
            }
        } else if (elementType.equals(Type.SHORT)) {
            c = new char[data.length];
            i2 = 0;
            while (i2 < data.length) {
                c[i2] = (char)(data[i2] + 32768);
                ++i2;
            }
        } else if (elementType.equals(Type.INTEGER)) {
            c = new char[data.length * 2];
            j = 0;
            i = 0;
            while (i < data.length) {
                int n = data[i];
                c[j++] = (char)(n >>> 16 & 0xFFFF);
                c[j++] = (char)(n >>> 0 & 0xFFFF);
                ++i;
            }
        } else {
            return;
        }
        ArrayList<String> image = new ArrayList<String>();
        ArrayList<Integer> startIndex = new ArrayList<Integer>();
        ArrayList<Integer> endIndex = new ArrayList<Integer>();
        StringBuffer sb = new StringBuffer();
        int utfLength = 0;
        startIndex.add(new Integer(0));
        int i3 = 0;
        while (i3 < c.length) {
            char n = c[i3];
            int len = 0;
            len = n == '\u0000' ? 2 : (n < '\u0800' ? 1 : (n < '\u8000' ? 2 : 3));
            if (utfLength + len > Short.MAX_VALUE) {
                image.add(sb.toString());
                endIndex.add(new Integer(i3));
                sb = new StringBuffer();
                utfLength = 0;
                startIndex.add(new Integer(i3));
            }
            sb.append(n);
            utfLength += len;
            ++i3;
        }
        if (sb.length() > 0) {
            image.add(sb.toString());
            endIndex.add(new Integer(data.length));
        } else {
            startIndex.remove(startIndex.size() - 1);
        }
        int bufStart = -1;
        int i4 = buf.size() - 1;
        while (i4 >= 0) {
            Instruction inst = (Instruction)buf.get(i4);
            if (inst.opcodeClass() == 188) {
                buf.removeRange(i4 + 1, buf.size());
                bufStart = i4;
                break;
            }
            --i4;
        }
        if (bufStart == -1) {
            return;
        }
        if (elementType.equals(Type.CHARACTER)) {
            array = m.newLocal(Type.OBJECT);
            buf.add(new Instruction(89, array));
            buf.add(new Instruction(58, array));
            int i5 = 0;
            while (i5 < image.size()) {
                String im = (String)image.get(i5);
                Integer start = (Integer)startIndex.get(i5);
                buf.add(new Instruction(18, im));
                buf.add(new Instruction(18, new Integer(0)));
                buf.add(new Instruction(18, new Integer(im.length())));
                buf.add(new Instruction(25, array));
                buf.add(new Instruction(18, start));
                buf.add(new Instruction(182, GET_CHARS));
                ++i5;
            }
        } else {
            array = m.newLocal(Type.OBJECT);
            LocalVariable index1 = m.newLocal(Type.INTEGER);
            LocalVariable index2 = m.newLocal(Type.INTEGER);
            LocalVariable tmp = null;
            if (elementType.equals(Type.BYTE) || elementType.equals(Type.BOOLEAN)) {
                tmp = m.newLocal(Type.CHARACTER);
            }
            int i6 = 0;
            while (i6 < image.size()) {
                Label top = m.newLabel();
                top.setStartsBlock(true);
                Label bottom = m.newLabel();
                bottom.setStartsBlock(true);
                String im = (String)image.get(i6);
                Integer start = (Integer)startIndex.get(i6);
                Integer end = (Integer)endIndex.get(i6);
                if (DEBUG) {
                    System.out.println("image " + im);
                    System.out.println("start " + start);
                    System.out.println("end   " + end);
                }
                buf.add(new Instruction(18, start));
                buf.add(new Instruction(54, index1));
                buf.add(new Instruction(18, new Integer(0)));
                buf.add(new Instruction(54, index2));
                buf.add(new Instruction(18, new Integer(im.length())));
                buf.add(new Instruction(188, Type.CHARACTER));
                buf.add(new Instruction(58, array));
                buf.add(new Instruction(18, im));
                buf.add(new Instruction(18, new Integer(0)));
                buf.add(new Instruction(18, new Integer(im.length())));
                buf.add(new Instruction(25, array));
                buf.add(new Instruction(18, new Integer(0)));
                buf.add(new Instruction(182, GET_CHARS));
                buf.add(top);
                if (elementType.equals(Type.SHORT)) {
                    buf.add(new Instruction(89));
                    buf.add(new Instruction(21, index1));
                    buf.add(new Instruction(132, new IncOperand(index1, 1)));
                    buf.add(new Instruction(25, array));
                    buf.add(new Instruction(21, index2));
                    buf.add(new Instruction(132, new IncOperand(index2, 1)));
                    buf.add(new Instruction(52));
                    buf.add(new Instruction(18, new Integer(32768)));
                    buf.add(new Instruction(100));
                    buf.add(new Instruction(147));
                    buf.add(new Instruction(86));
                } else if (elementType.equals(Type.BYTE) || elementType.equals(Type.BOOLEAN)) {
                    buf.add(new Instruction(25, array));
                    buf.add(new Instruction(21, index2));
                    buf.add(new Instruction(132, new IncOperand(index2, 1)));
                    buf.add(new Instruction(52));
                    buf.add(new Instruction(54, tmp));
                    buf.add(new Instruction(89));
                    buf.add(new Instruction(21, index1));
                    buf.add(new Instruction(132, new IncOperand(index1, 1)));
                    buf.add(new Instruction(21, tmp));
                    buf.add(new Instruction(18, new Integer(8)));
                    buf.add(new Instruction(124));
                    buf.add(new Instruction(145));
                    buf.add(new Instruction(84));
                    buf.add(new Instruction(21, index1));
                    buf.add(new Instruction(18, end));
                    buf.add(new Instruction(162, bottom));
                    Label nobreak = m.newLabel();
                    nobreak.setStartsBlock(true);
                    buf.add(nobreak);
                    buf.add(new Instruction(89));
                    buf.add(new Instruction(21, index1));
                    buf.add(new Instruction(132, new IncOperand(index1, 1)));
                    buf.add(new Instruction(21, tmp));
                    buf.add(new Instruction(18, new Integer(255)));
                    buf.add(new Instruction(126));
                    buf.add(new Instruction(145));
                    buf.add(new Instruction(84));
                } else if (elementType.equals(Type.INTEGER)) {
                    buf.add(new Instruction(89));
                    buf.add(new Instruction(21, index1));
                    buf.add(new Instruction(132, new IncOperand(index1, 1)));
                    buf.add(new Instruction(25, array));
                    buf.add(new Instruction(21, index2));
                    buf.add(new Instruction(132, new IncOperand(index2, 1)));
                    buf.add(new Instruction(52));
                    buf.add(new Instruction(18, new Integer(16)));
                    buf.add(new Instruction(120));
                    buf.add(new Instruction(25, array));
                    buf.add(new Instruction(21, index2));
                    buf.add(new Instruction(132, new IncOperand(index2, 1)));
                    buf.add(new Instruction(52));
                    buf.add(new Instruction(128));
                    buf.add(new Instruction(79));
                }
                buf.add(new Instruction(21, index1));
                buf.add(new Instruction(18, end));
                buf.add(new Instruction(161, top));
                buf.add(bottom);
                ++i6;
            }
        }
        if (DEBUG) {
            i = bufStart;
            while (i < buf.size()) {
                System.out.println("fill[" + i + "] " + buf.get(i));
                ++i;
            }
        }
    }
}

