/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.instrumentation.util;

import com.db4o.foundation.io.File4;
import com.db4o.foundation.io.Path4;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipFileExtraction {
    private final ZipFile _zipFile;
    private final String _targetDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZipFileExtraction(File file, String string) throws IOException {
        this._targetDir = string;
        this._zipFile = new ZipFile(file);
        try {
            this.extractEntries();
        }
        finally {
            this._zipFile.close();
        }
    }

    private void extractEntries() throws IOException {
        Enumeration<? extends ZipEntry> enumeration = this._zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            this.extractEntry(zipEntry);
        }
    }

    private void extractEntry(ZipEntry zipEntry) throws IOException {
        if (zipEntry.isDirectory()) {
            File4.mkdirs((String)this.targetPathFor(zipEntry));
            return;
        }
        this.extractFileEntry(zipEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractFileEntry(ZipEntry zipEntry) throws FileNotFoundException, IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(this.targetPathFor(zipEntry));
        try {
            InputStream inputStream = this._zipFile.getInputStream(zipEntry);
            try {
                this.copy(inputStream, fileOutputStream);
            }
            finally {
                inputStream.close();
            }
        }
        finally {
            fileOutputStream.close();
        }
    }

    private void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[65536];
        int n = 0;
        while (-1 != (n = inputStream.read(byArray))) {
            outputStream.write(byArray, 0, n);
        }
    }

    private String targetPathFor(ZipEntry zipEntry) {
        String string = Path4.combine((String)this._targetDir, (String)zipEntry.getName());
        File4.mkdirs((String)Path4.getDirectoryName((String)string));
        return string;
    }
}

