/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.instrumentation.util;

import com.db4o.foundation.io.File4;
import com.db4o.instrumentation.util.ZipFileWriter;
import java.io.File;
import java.io.IOException;

public class ZipFileCreation {
    private final ZipFileWriter _zipFile;
    private final File _baseDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZipFileCreation(String string, File file) throws IOException {
        this._baseDir = new File(string).getCanonicalFile();
        this._zipFile = new ZipFileWriter(file);
        try {
            this.writeEntries(this._baseDir.listFiles());
        }
        finally {
            this._zipFile.close();
        }
    }

    private void writeEntries(File[] fileArray) throws IOException {
        for (int i = 0; i < fileArray.length; ++i) {
            this.writeEntry(fileArray[i]);
        }
    }

    private void writeEntry(File file) throws IOException {
        if (file.isDirectory()) {
            this.writeEntries(file.listFiles());
            return;
        }
        this.writeFileEntry(file);
    }

    private void writeFileEntry(File file) throws IOException {
        this._zipFile.writeEntry(this.relativePath(file).replace('\\', '/'), this.readAllBytes(file));
    }

    private byte[] readAllBytes(File file) throws IOException {
        return File4.readAllBytes((String)file.getAbsolutePath());
    }

    private String relativePath(File file) throws IOException {
        String string = this._baseDir.getAbsolutePath();
        String string2 = file.getCanonicalPath();
        this.assertPathPrefix(string, string2);
        return string2.substring(string.length() + 1);
    }

    private void assertPathPrefix(String string, String string2) {
        if (!string2.startsWith(string)) {
            throw new IllegalStateException();
        }
    }
}

