/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.instrumentation.main;

import com.db4o.foundation.io.Directory4;
import com.db4o.foundation.io.Path4;
import com.db4o.instrumentation.core.BloatClassEdit;
import com.db4o.instrumentation.main.Db4oFileInstrumentor;
import com.db4o.instrumentation.util.ZipFileCreation;
import com.db4o.instrumentation.util.ZipFileExtraction;
import java.io.File;
import java.io.IOException;

public class Db4oJarEnhancer {
    private final Db4oFileInstrumentor _fileEnhancer;

    public Db4oJarEnhancer(BloatClassEdit bloatClassEdit) {
        this._fileEnhancer = new Db4oFileInstrumentor(bloatClassEdit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enhance(File file, File file2, String[] stringArray) throws Exception {
        String string = this.tempDir(file.getName());
        try {
            this.extractJarTo(file, string);
            this.enhance(string, stringArray);
            this.makeJarFromDirectory(string, file2);
        }
        finally {
            this.deleteDirectory(string);
        }
    }

    private void deleteDirectory(String string) {
        Directory4.delete((String)string, (boolean)true);
    }

    private void enhance(String string, String[] stringArray) throws Exception {
        this._fileEnhancer.enhance(string, string, stringArray);
    }

    private String tempDir(String string) {
        return Path4.combine((String)Path4.getTempPath(), (String)(string + "-working"));
    }

    private void extractJarTo(File file, String string) throws IOException {
        new ZipFileExtraction(file, string);
    }

    private void makeJarFromDirectory(String string, File file) throws IOException {
        new ZipFileCreation(string, file);
    }
}

