/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.instrumentation.main;

import EDU.purdue.cs.bloat.editor.ClassEditor;
import EDU.purdue.cs.bloat.file.ClassFileLoader;
import EDU.purdue.cs.bloat.file.ClassSource;
import EDU.purdue.cs.bloat.file.DefaultClassSource;
import com.db4o.instrumentation.core.BloatClassEdit;
import com.db4o.instrumentation.core.BloatLoaderContext;
import com.db4o.instrumentation.core.CompositeBloatClassEdit;
import com.db4o.instrumentation.core.InstrumentationStatus;
import com.db4o.instrumentation.file.DefaultFilePathRoot;
import com.db4o.instrumentation.file.FilePathRoot;
import com.db4o.instrumentation.file.InstrumentationClassSource;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Iterator;

public class Db4oFileInstrumentor {
    private final BloatClassEdit _classEdit;

    public Db4oFileInstrumentor(BloatClassEdit bloatClassEdit) {
        this._classEdit = bloatClassEdit;
    }

    public Db4oFileInstrumentor(BloatClassEdit[] bloatClassEditArray) {
        this(new CompositeBloatClassEdit(bloatClassEditArray));
    }

    public void enhance(String string, String string2, String[] stringArray) throws Exception {
        this.enhance(new DefaultFilePathRoot(new String[]{string}, ".class"), string2, stringArray);
    }

    public void enhance(FilePathRoot filePathRoot, String string, String[] stringArray) throws Exception {
        this.enhance(new DefaultClassSource(), filePathRoot, string, stringArray);
    }

    private void enhance(ClassSource classSource, FilePathRoot filePathRoot, String string, String[] stringArray) throws Exception {
        String[] stringArray2;
        File file = new File(string);
        String[] stringArray3 = filePathRoot.rootDirs();
        for (int i = 0; i < stringArray3.length; ++i) {
            stringArray2 = new File(stringArray3[i]);
            this.assertSourceDir((File)stringArray2);
        }
        ClassFileLoader classFileLoader = new ClassFileLoader(classSource);
        stringArray2 = this.fullClasspath(filePathRoot, stringArray);
        this.setOutputDir(classFileLoader, file);
        this.setClasspath(classFileLoader, stringArray2);
        URL[] uRLArray = this.classpathToURLs(stringArray2);
        URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray, ClassLoader.getSystemClassLoader());
        this.enhance(filePathRoot, file, uRLClassLoader, new BloatLoaderContext(classFileLoader));
        classFileLoader.done();
    }

    private void enhance(FilePathRoot filePathRoot, File file, ClassLoader classLoader, BloatLoaderContext bloatLoaderContext) throws Exception {
        Iterator iterator = filePathRoot.files();
        while (iterator.hasNext()) {
            InstrumentationClassSource instrumentationClassSource = (InstrumentationClassSource)iterator.next();
            this.enhanceFile(instrumentationClassSource, file, classLoader, bloatLoaderContext);
        }
    }

    private void enhanceFile(InstrumentationClassSource instrumentationClassSource, File file, ClassLoader classLoader, BloatLoaderContext bloatLoaderContext) throws IOException, ClassNotFoundException {
        System.err.println("Processing " + instrumentationClassSource.className());
        ClassEditor classEditor = bloatLoaderContext.classEditor(instrumentationClassSource.className());
        InstrumentationStatus instrumentationStatus = this._classEdit.enhance(classEditor, classLoader, bloatLoaderContext);
        System.err.println("enhance " + instrumentationClassSource.className() + ": " + (instrumentationStatus.isInstrumented() ? "ok" : "skipped"));
        if (!instrumentationStatus.isInstrumented()) {
            File file2 = instrumentationClassSource.targetPath(file);
            file2.getParentFile().mkdirs();
            this.copy(instrumentationClassSource, file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(InstrumentationClassSource instrumentationClassSource, File file) throws IOException {
        if (file.equals(instrumentationClassSource.sourceFile())) {
            return;
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(instrumentationClassSource.inputStream(), 4096);
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            try {
                this.copy(4096, bufferedInputStream, bufferedOutputStream);
            }
            finally {
                bufferedOutputStream.close();
            }
        }
        finally {
            bufferedInputStream.close();
        }
    }

    private void copy(int n, BufferedInputStream bufferedInputStream, BufferedOutputStream bufferedOutputStream) throws IOException {
        byte[] byArray = new byte[n];
        int n2 = -1;
        while ((n2 = bufferedInputStream.read(byArray)) >= 0) {
            bufferedOutputStream.write(byArray, 0, n2);
        }
    }

    private String[] fullClasspath(FilePathRoot filePathRoot, String[] stringArray) throws IOException {
        String[] stringArray2 = filePathRoot.rootDirs();
        String[] stringArray3 = new String[stringArray2.length + stringArray.length];
        System.arraycopy(stringArray2, 0, stringArray3, 0, stringArray2.length);
        System.arraycopy(stringArray, 0, stringArray3, stringArray2.length, stringArray.length);
        return stringArray3;
    }

    private void setOutputDir(ClassFileLoader classFileLoader, File file) {
        classFileLoader.setOutputDir(file);
    }

    private void assertSourceDir(File file) throws IOException {
        if (!file.isDirectory()) {
            // empty if block
        }
    }

    private void setClasspath(ClassFileLoader classFileLoader, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            classFileLoader.appendClassPath(stringArray[i]);
        }
    }

    private URL[] classpathToURLs(String[] stringArray) throws MalformedURLException {
        URL[] uRLArray = new URL[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            uRLArray[i] = this.toURL(stringArray[i]);
        }
        return uRLArray;
    }

    private URL toURL(String string) throws MalformedURLException {
        return new File(string).toURL();
    }
}

