/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.instrumentation.main;

import EDU.purdue.cs.bloat.context.BloatingClassLoader;
import EDU.purdue.cs.bloat.editor.ClassEditor;
import com.db4o.instrumentation.classfilter.AcceptAllClassesFilter;
import com.db4o.instrumentation.core.BloatClassEdit;
import com.db4o.instrumentation.core.BloatLoaderContext;
import com.db4o.instrumentation.core.ClassFilter;
import com.db4o.instrumentation.util.BloatUtil;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class BloatInstrumentingClassLoader
extends BloatingClassLoader {
    private final Map _cache = new HashMap();
    private final ClassFilter _filter;
    private final BloatClassEdit _edit;
    private final BloatLoaderContext _loaderContext = new BloatLoaderContext(this.getEditorContext());

    public BloatInstrumentingClassLoader(URL[] uRLArray, ClassLoader classLoader, BloatClassEdit bloatClassEdit) {
        this(uRLArray, classLoader, new AcceptAllClassesFilter(), bloatClassEdit);
    }

    public BloatInstrumentingClassLoader(URL[] uRLArray, ClassLoader classLoader, ClassFilter classFilter, BloatClassEdit bloatClassEdit) {
        super(uRLArray, classLoader);
        this._filter = classFilter;
        this._edit = bloatClassEdit;
    }

    protected synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        if (this._cache.containsKey(string)) {
            return (Class)this._cache.get(string);
        }
        Class<?> clazz = super.loadClass(string, bl);
        if (this.mustDelegate(string)) {
            return clazz;
        }
        Class clazz2 = this._filter.accept(clazz) ? this.findClass(string) : this.findRawClass(string);
        this._cache.put(clazz2.getName(), clazz2);
        if (bl) {
            this.resolveClass(clazz2);
        }
        return clazz2;
    }

    private boolean mustDelegate(String string) {
        return BloatUtil.isPlatformClassName(string) || string.startsWith("com.db4o.") && string.indexOf("test.") < 0 && string.indexOf("samples.") < 0;
    }

    private Class findRawClass(String string) throws ClassNotFoundException {
        try {
            String string2 = string.replace('.', '/') + ".class";
            InputStream inputStream = ((ClassLoader)this).getResourceAsStream(string2);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[4096];
            int n = 0;
            while ((n = inputStream.read(byArray)) >= 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            inputStream.close();
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            return super.defineClass(string, byArray2, 0, byArray2.length);
        }
        catch (Exception exception) {
            throw new ClassNotFoundException(string, exception);
        }
    }

    protected void bloat(ClassEditor classEditor) {
        this._edit.enhance(classEditor, this.getParent(), this._loaderContext);
    }
}

