/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.instrumentation.file;

import com.db4o.instrumentation.file.InstrumentationClassSource;
import com.db4o.instrumentation.util.BloatUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileInstrumentationClassSource
implements Comparable,
InstrumentationClassSource {
    private final File _root;
    private final File _file;

    public FileInstrumentationClassSource(File file, File file2) {
        this._root = file;
        this._file = file2;
    }

    public File root() {
        return this._root;
    }

    public File file() {
        return this._file;
    }

    public String className() throws IOException {
        return BloatUtil.classNameForPath(this.classPath());
    }

    private String classPath() throws IOException {
        return this._file.getCanonicalPath().substring(this._root.getCanonicalPath().length() + 1);
    }

    public File targetPath(File file) throws IOException {
        return new File(file, this.classPath());
    }

    public int hashCode() {
        return 43 * this._root.hashCode() + this._file.hashCode();
    }

    public InputStream inputStream() throws IOException {
        return new FileInputStream(this._file);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        FileInstrumentationClassSource fileInstrumentationClassSource = (FileInstrumentationClassSource)object;
        return this._root.equals(fileInstrumentationClassSource._root) && this._file.equals(fileInstrumentationClassSource._file);
    }

    public int compareTo(Object object) {
        return this._file.compareTo(((FileInstrumentationClassSource)object)._file);
    }

    public String toString() {
        return this._file + " [" + this._root + "]";
    }

    public File sourceFile() {
        return this._file;
    }
}

