/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.instrumentation.file;

import com.db4o.instrumentation.file.FileInstrumentationClassSource;
import com.db4o.instrumentation.file.FilePathRoot;
import com.db4o.instrumentation.file.InstrumentationClassSource;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;

public class DefaultFilePathRoot
implements FilePathRoot {
    private final String[] _rootDirs;
    private final String _extension;

    public DefaultFilePathRoot(String[] stringArray) {
        this(stringArray, "");
    }

    public DefaultFilePathRoot(String[] stringArray, String string) {
        this._rootDirs = stringArray;
        this._extension = string;
    }

    public Iterator files() {
        return new FileSystemIterator(this._rootDirs, this._extension);
    }

    public String[] rootDirs() {
        return this._rootDirs;
    }

    private static class FileSystemIterator
    implements Iterator {
        private final String _extension;
        private LinkedList _stack = new LinkedList();

        public FileSystemIterator(String[] stringArray, String string) {
            this._extension = string;
            for (int i = 0; i < stringArray.length; ++i) {
                File file = new File(stringArray[i]);
                this.push(new FileInstrumentationClassSource(file, file));
            }
            this.advanceQueue();
        }

        public boolean hasNext() {
            return !this._stack.isEmpty();
        }

        public Object next() {
            FileInstrumentationClassSource fileInstrumentationClassSource = this.pop();
            this.advanceQueue();
            return fileInstrumentationClassSource;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void advanceQueue() {
            while (!this._stack.isEmpty() && !this.accept(this.peek())) {
                FileInstrumentationClassSource fileInstrumentationClassSource = this.pop();
                if (!fileInstrumentationClassSource.file().isDirectory()) continue;
                File[] fileArray = fileInstrumentationClassSource.file().listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    this._stack.addFirst(new FileInstrumentationClassSource(fileInstrumentationClassSource.root(), fileArray[i]));
                }
            }
        }

        private boolean accept(FileInstrumentationClassSource fileInstrumentationClassSource) {
            return fileInstrumentationClassSource.file().isFile() && fileInstrumentationClassSource.file().getName().endsWith(this._extension);
        }

        private void push(InstrumentationClassSource instrumentationClassSource) {
            this._stack.addFirst(instrumentationClassSource);
        }

        private FileInstrumentationClassSource pop() {
            return (FileInstrumentationClassSource)this._stack.removeFirst();
        }

        private FileInstrumentationClassSource peek() {
            return (FileInstrumentationClassSource)this._stack.getFirst();
        }
    }
}

