/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.instrumentation.core;

import EDU.purdue.cs.bloat.cfg.FlowGraph;
import EDU.purdue.cs.bloat.context.CachingBloatContext;
import EDU.purdue.cs.bloat.editor.ClassEditor;
import EDU.purdue.cs.bloat.editor.EditorContext;
import EDU.purdue.cs.bloat.editor.FieldEditor;
import EDU.purdue.cs.bloat.editor.MethodEditor;
import EDU.purdue.cs.bloat.editor.Type;
import EDU.purdue.cs.bloat.reflect.ClassInfoLoader;
import EDU.purdue.cs.bloat.reflect.FieldInfo;
import EDU.purdue.cs.bloat.reflect.MethodInfo;
import com.db4o.instrumentation.bloat.BloatReferenceProvider;
import com.db4o.instrumentation.util.BloatUtil;
import java.util.ConcurrentModificationException;
import java.util.LinkedList;

public class BloatLoaderContext {
    private EditorContext context;
    private final BloatReferenceProvider references;

    public BloatLoaderContext(ClassInfoLoader classInfoLoader) {
        this(new CachingBloatContext(classInfoLoader, new LinkedList(), false));
    }

    public BloatLoaderContext(EditorContext editorContext) {
        this.context = editorContext;
        this.references = new BloatReferenceProvider();
    }

    public BloatReferenceProvider references() {
        return this.references;
    }

    public FlowGraph flowGraph(String string, String string2) throws ClassNotFoundException {
        return this.flowGraph(string, string2, null);
    }

    public FlowGraph flowGraph(String string, String string2, Type[] typeArray) throws ClassNotFoundException {
        ClassEditor classEditor = this.classEditor(string);
        return this.flowGraph(classEditor, string2, typeArray);
    }

    public FlowGraph flowGraph(ClassEditor classEditor, String string, Type[] typeArray) throws ClassNotFoundException {
        MethodEditor methodEditor = this.method(classEditor, string, typeArray);
        return methodEditor == null ? null : new FlowGraph(methodEditor);
    }

    public MethodEditor method(ClassEditor classEditor, String string, Type[] typeArray) throws ClassNotFoundException {
        ClassEditor classEditor2 = classEditor;
        while (classEditor2 != null) {
            MethodInfo[] methodInfoArray = classEditor2.methods();
            for (int i = 0; i < methodInfoArray.length; ++i) {
                MethodEditor methodEditor = this.context.editMethod(methodInfoArray[i]);
                if (!methodEditor.name().equals(string) || !this.signatureMatchesTypes(typeArray, methodEditor)) continue;
                return methodEditor;
            }
            classEditor2 = this.classEditor(classEditor2.superclass());
        }
        return null;
    }

    public FieldEditor field(ClassEditor classEditor, String string, Type type) throws ClassNotFoundException {
        ClassEditor classEditor2 = classEditor;
        while (classEditor2 != null) {
            FieldInfo[] fieldInfoArray = classEditor2.fields();
            for (int i = 0; i < fieldInfoArray.length; ++i) {
                FieldInfo fieldInfo = fieldInfoArray[i];
                FieldEditor fieldEditor = this.context.editField(fieldInfo);
                if (!fieldEditor.name().equals(string) || !type.equals(fieldEditor.type())) continue;
                return fieldEditor;
            }
            classEditor2 = this.classEditor(classEditor2.superclass());
        }
        return null;
    }

    public ClassEditor classEditor(Type type) throws ClassNotFoundException {
        return type == null ? null : this.classEditor(BloatUtil.normalizeClassName(type));
    }

    private boolean signatureMatchesTypes(Type[] typeArray, MethodEditor methodEditor) {
        int n;
        if (typeArray == null) {
            return true;
        }
        Type[] typeArray2 = methodEditor.paramTypes();
        int n2 = n = methodEditor.isStatic() || methodEditor.isConstructor() ? 0 : 1;
        if (typeArray.length != typeArray2.length - n) {
            return false;
        }
        for (int i = 0; i < typeArray.length; ++i) {
            if (typeArray[i].className().equals(typeArray2[i + n].className())) continue;
            return false;
        }
        return true;
    }

    public ClassEditor classEditor(String string) throws ClassNotFoundException {
        return this.context.editClass(string);
    }

    public ClassEditor classEditor(int n, String string, Type type, Type[] typeArray) {
        return this.context.newClass(n, string, type, typeArray);
    }

    public Type superType(Type type) throws ClassNotFoundException {
        return this.context.editClass(type).superclass();
    }

    public void commit() {
        try {
            this.context.commit();
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            concurrentModificationException.printStackTrace();
            throw concurrentModificationException;
        }
    }
}

