/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.instrumentation.bloat;

import EDU.purdue.cs.bloat.editor.Type;
import com.db4o.instrumentation.api.TypeRef;
import com.db4o.instrumentation.bloat.BloatRef;
import com.db4o.instrumentation.bloat.BloatReferenceProvider;
import com.db4o.instrumentation.util.BloatUtil;

public class BloatTypeRef
extends BloatRef
implements TypeRef {
    private final Type _type;

    public static Type[] bloatTypes(TypeRef[] typeRefArray) {
        Type[] typeArray = new Type[typeRefArray.length];
        for (int i = 0; i < typeRefArray.length; ++i) {
            typeArray[i] = BloatTypeRef.bloatType(typeRefArray[i]);
        }
        return typeArray;
    }

    public static Type bloatType(TypeRef typeRef) {
        return ((BloatTypeRef)typeRef).type();
    }

    BloatTypeRef(BloatReferenceProvider bloatReferenceProvider, Type type) {
        super(bloatReferenceProvider);
        this._type = type;
    }

    public Type type() {
        return this._type;
    }

    public TypeRef elementType() {
        return this.typeRef(this._type.elementType());
    }

    public boolean isPrimitive() {
        return this._type.isPrimitive();
    }

    public String name() {
        if (this.isPrimitive()) {
            return this.primitiveName();
        }
        return BloatUtil.normalizeClassName(this._type);
    }

    private String primitiveName() {
        switch (this._type.className().charAt(0)) {
            case '[': {
                return this.elementType().name() + "[]";
            }
            case 'C': {
                return "char";
            }
            case 'B': {
                return "byte";
            }
            case 'S': {
                return "short";
            }
            case 'I': {
                return "int";
            }
            case 'J': {
                return "long";
            }
            case 'Z': {
                return "boolean";
            }
            case 'F': {
                return "float";
            }
            case 'D': {
                return "double";
            }
        }
        throw new IllegalStateException();
    }

    public String toString() {
        return this.name();
    }
}

