/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.instrumentation.bloat;

import com.db4o.foundation.ArgumentNullException;
import com.db4o.instrumentation.api.InstrumentationException;
import com.db4o.instrumentation.api.MethodRef;
import com.db4o.instrumentation.api.NativeClassFactory;
import com.db4o.instrumentation.api.ReferenceResolver;
import com.db4o.instrumentation.api.TypeRef;
import java.lang.reflect.Method;

public class BloatReferenceResolver
implements ReferenceResolver {
    private final NativeClassFactory _loader;

    public BloatReferenceResolver(NativeClassFactory nativeClassFactory) {
        if (null == nativeClassFactory) {
            throw new ArgumentNullException();
        }
        this._loader = nativeClassFactory;
    }

    public Method resolve(MethodRef methodRef) {
        Class clazz = this.resolve(methodRef.declaringType());
        Class[] classArray = this.resolve(methodRef.paramTypes());
        try {
            return clazz.getDeclaredMethod(methodRef.name(), classArray);
        }
        catch (Exception exception) {
            throw new InstrumentationException(exception);
        }
    }

    private Class[] resolve(TypeRef[] typeRefArray) {
        Class[] classArray = new Class[typeRefArray.length];
        for (int i = 0; i < typeRefArray.length; ++i) {
            classArray[i] = this.resolve(typeRefArray[i]);
        }
        return classArray;
    }

    private Class resolve(TypeRef typeRef) {
        try {
            return this._loader.forName(typeRef.name());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InstrumentationException(classNotFoundException);
        }
    }
}

