/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.instrumentation.bloat;

import EDU.purdue.cs.bloat.editor.ClassEditor;
import EDU.purdue.cs.bloat.editor.Instruction;
import EDU.purdue.cs.bloat.editor.LocalVariable;
import EDU.purdue.cs.bloat.editor.MemberRef;
import EDU.purdue.cs.bloat.editor.MethodEditor;
import EDU.purdue.cs.bloat.editor.Type;
import com.db4o.instrumentation.api.CallingConvention;
import com.db4o.instrumentation.api.FieldRef;
import com.db4o.instrumentation.api.MethodBuilder;
import com.db4o.instrumentation.api.MethodRef;
import com.db4o.instrumentation.api.ReferenceProvider;
import com.db4o.instrumentation.api.TypeRef;
import com.db4o.instrumentation.bloat.BloatMemberRef;
import com.db4o.instrumentation.bloat.BloatReferenceProvider;
import com.db4o.instrumentation.bloat.BloatTypeRef;
import com.db4o.instrumentation.util.LabelGenerator;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

class BloatMethodBuilder
implements MethodBuilder {
    private final MethodEditor methodEditor;
    private final LabelGenerator _labelGen;
    private final BloatReferenceProvider _references;
    private final Map _conversions = new HashMap();
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Boolean;

    BloatMethodBuilder(BloatReferenceProvider bloatReferenceProvider, ClassEditor classEditor, String string, TypeRef typeRef, TypeRef[] typeRefArray) {
        this._references = bloatReferenceProvider;
        this.methodEditor = new MethodEditor(classEditor, 1, BloatTypeRef.bloatType(typeRef), string, BloatTypeRef.bloatTypes(typeRefArray), new Type[0]);
        this._labelGen = new LabelGenerator();
        this.methodEditor.addLabel(this._labelGen.createLabel(true));
        this.setUpConversions();
    }

    public void invoke(MethodRef methodRef, CallingConvention callingConvention) {
        if (callingConvention == CallingConvention.INTERFACE) {
            this.invokeInterface(methodRef);
        } else if (callingConvention == CallingConvention.STATIC) {
            this.invokeStatic(methodRef);
        } else {
            this.invokeVirtual(methodRef);
        }
    }

    private void invokeInterface(MethodRef methodRef) {
        this.addInstruction(185, this.memberRef(methodRef));
    }

    private void invokeVirtual(MethodRef methodRef) {
        this.addInstruction(182, this.memberRef(methodRef));
    }

    private void invokeStatic(MethodRef methodRef) {
        this.addInstruction(184, this.memberRef(methodRef));
    }

    public void ldc(Object object) {
        this.addInstruction(18, this.coerce(object));
    }

    public void loadArgument(int n) {
        this.addInstruction(25, new LocalVariable(n));
    }

    public void pop() {
        this.addInstruction(87);
    }

    private MemberRef memberRef(Object object) {
        return ((BloatMemberRef)object).member();
    }

    public void endMethod() {
        this.addLabel(false);
        this.addInstruction(177);
        this.addLabel(true);
        this.methodEditor.commit();
    }

    private void addLabel(boolean bl) {
        this.methodEditor.addLabel(this._labelGen.createLabel(bl));
    }

    public void addInstruction(int n) {
        this.methodEditor.addInstruction(n);
    }

    public void print(PrintStream printStream) {
        this.methodEditor.print(printStream);
    }

    public void loadArrayElement(TypeRef typeRef) {
        this.addInstruction(this.arrayElementOpcode(typeRef));
    }

    private int arrayElementOpcode(TypeRef typeRef) {
        if (typeRef == this.integerType()) {
            return 46;
        }
        if (typeRef == this.longType()) {
            return 47;
        }
        if (typeRef == this.floatType()) {
            return 48;
        }
        if (typeRef == this.doubleType()) {
            return 49;
        }
        return 50;
    }

    private TypeRef doubleType() {
        return this.type(Double.TYPE);
    }

    private TypeRef floatType() {
        return this.type(Float.TYPE);
    }

    private TypeRef longType() {
        return this.type(Long.TYPE);
    }

    private TypeRef integerType() {
        return this.type(Integer.TYPE);
    }

    private TypeRef type(Class clazz) {
        return this._references.forType(clazz);
    }

    public void addInstruction(Instruction instruction) {
        this.methodEditor.addInstruction(instruction);
    }

    public void addInstruction(int n, Object object) {
        this.methodEditor.addInstruction(n, object);
    }

    public void add(TypeRef typeRef) {
        this.addInstruction(this.addOpcode(typeRef));
    }

    private int addOpcode(TypeRef typeRef) {
        if (typeRef == this.doubleType()) {
            return 99;
        }
        if (typeRef == this.floatType()) {
            return 98;
        }
        if (typeRef == this.longType()) {
            return 97;
        }
        return 96;
    }

    public void subtract(TypeRef typeRef) {
        this.addInstruction(this.subOpcode(typeRef));
    }

    private int subOpcode(TypeRef typeRef) {
        if (typeRef == this.doubleType()) {
            return 103;
        }
        if (typeRef == this.floatType()) {
            return 102;
        }
        if (typeRef == this.longType()) {
            return 101;
        }
        return 100;
    }

    public void multiply(TypeRef typeRef) {
        this.addInstruction(this.multOpcode(typeRef));
    }

    private int multOpcode(TypeRef typeRef) {
        if (typeRef == this.doubleType()) {
            return 107;
        }
        if (typeRef == this.floatType()) {
            return 106;
        }
        if (typeRef == this.longType()) {
            return 105;
        }
        return 104;
    }

    public void divide(TypeRef typeRef) {
        this.addInstruction(this.divOpcode(typeRef));
    }

    private int divOpcode(TypeRef typeRef) {
        if (typeRef == this.doubleType()) {
            return 111;
        }
        if (typeRef == this.floatType()) {
            return 110;
        }
        if (typeRef == this.longType()) {
            return 109;
        }
        return 108;
    }

    public void invoke(Method method) {
        MethodRef methodRef = this._references.forMethod(method);
        if (this.isStatic(method)) {
            this.invokeStatic(methodRef);
        } else {
            this.invokeVirtual(methodRef);
        }
    }

    private boolean isStatic(Method method) {
        return (method.getModifiers() & 8) != 0;
    }

    public ReferenceProvider references() {
        return this._references;
    }

    public void loadField(FieldRef fieldRef) {
        this.addInstruction(180, this.memberRef(fieldRef));
    }

    public void loadStaticField(FieldRef fieldRef) {
        this.addInstruction(178, this.memberRef(fieldRef));
    }

    public void box(TypeRef typeRef) {
        Class[] classArray = (Class[])this._conversions.get(typeRef);
        if (null == classArray) {
            return;
        }
        Class clazz = classArray[0];
        Class clazz2 = classArray[1];
        LocalVariable localVariable = this.methodEditor.newLocal(this.bloatType(clazz2));
        this.addInstruction(this.storeOpcode(clazz2), localVariable);
        this.addInstruction(187, this.bloatType(clazz));
        this.addInstruction(89);
        this.addInstruction(this.loadOpcode(clazz2), localVariable);
        this.addInstruction(183, this.memberRef(this._references.forMethod(this.type(classArray[0]), "<init>", new TypeRef[]{this.type(clazz2)}, this.type(Void.TYPE))));
    }

    private int loadOpcode(Class clazz) {
        if (clazz == Long.TYPE) {
            return 22;
        }
        if (clazz == Float.TYPE) {
            return 23;
        }
        if (clazz == Double.TYPE) {
            return 24;
        }
        return 21;
    }

    private int storeOpcode(Class clazz) {
        if (clazz == Long.TYPE) {
            return 55;
        }
        if (clazz == Float.TYPE) {
            return 56;
        }
        if (clazz == Double.TYPE) {
            return 57;
        }
        return 54;
    }

    private Type bloatType(Class clazz) {
        return this._references.bloatType(clazz);
    }

    private void setUpConversions() {
        this.setUpConversion(new Class[]{class$java$lang$Integer == null ? (class$java$lang$Integer = BloatMethodBuilder.class$("java.lang.Integer")) : class$java$lang$Integer, Integer.TYPE});
        this.setUpConversion(new Class[]{class$java$lang$Long == null ? (class$java$lang$Long = BloatMethodBuilder.class$("java.lang.Long")) : class$java$lang$Long, Long.TYPE});
        this.setUpConversion(new Class[]{class$java$lang$Short == null ? (class$java$lang$Short = BloatMethodBuilder.class$("java.lang.Short")) : class$java$lang$Short, Short.TYPE});
        this.setUpConversion(new Class[]{class$java$lang$Byte == null ? (class$java$lang$Byte = BloatMethodBuilder.class$("java.lang.Byte")) : class$java$lang$Byte, Byte.TYPE});
        this.setUpConversion(new Class[]{class$java$lang$Double == null ? (class$java$lang$Double = BloatMethodBuilder.class$("java.lang.Double")) : class$java$lang$Double, Double.TYPE});
        this.setUpConversion(new Class[]{class$java$lang$Float == null ? (class$java$lang$Float = BloatMethodBuilder.class$("java.lang.Float")) : class$java$lang$Float, Float.TYPE});
        this.setUpConversion(new Class[]{class$java$lang$Boolean == null ? (class$java$lang$Boolean = BloatMethodBuilder.class$("java.lang.Boolean")) : class$java$lang$Boolean, Boolean.TYPE});
    }

    private void setUpConversion(Class[] classArray) {
        for (int i = 0; i < classArray.length; ++i) {
            this._conversions.put(this.type(classArray[i]), classArray);
        }
    }

    private Object coerce(Object object) {
        if (object instanceof Boolean) {
            return (Boolean)object != false ? new Integer(1) : new Integer(0);
        }
        if (object instanceof Character) {
            return new Integer(((Character)object).charValue());
        }
        if (object instanceof Byte || object instanceof Short) {
            return new Integer(((Number)object).intValue());
        }
        return object;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

