/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.instrumentation.ant;

import com.db4o.instrumentation.ant.AntClassEditFactory;
import com.db4o.instrumentation.ant.AntFileSetPathRoot;
import com.db4o.instrumentation.classfilter.CompositeOrClassFilter;
import com.db4o.instrumentation.classfilter.JarFileClassFilter;
import com.db4o.instrumentation.core.BloatClassEdit;
import com.db4o.instrumentation.core.ClassFilter;
import com.db4o.instrumentation.core.CompositeBloatClassEdit;
import com.db4o.instrumentation.core.NullClassEdit;
import com.db4o.instrumentation.main.Db4oFileInstrumentor;
import com.db4o.instrumentation.main.Db4oJarEnhancer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarFile;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.resources.FileResource;

public class Db4oFileEnhancerAntTask
extends Task {
    private final List _sources = new ArrayList();
    private String _targetDir;
    private final List _classPath = new ArrayList();
    private final List _editFactories = new ArrayList();
    private final List _jars = new ArrayList();
    private String _jarTargetDir;

    public void add(AntClassEditFactory antClassEditFactory) {
        this._editFactories.add(antClassEditFactory);
    }

    public void addSources(FileSet fileSet) {
        this._sources.add(fileSet);
    }

    public void addJars(FileSet fileSet) {
        this._jars.add(fileSet);
    }

    public void setClassTargetDir(String string) {
        this._targetDir = string;
    }

    public void setJarTargetdir(String string) {
        this._jarTargetDir = string;
    }

    public void addClasspath(Path path) {
        this._classPath.add(path);
    }

    public void execute() {
        try {
            FileSet[] fileSetArray = this._sources.toArray(new FileSet[this._sources.size()]);
            AntFileSetPathRoot antFileSetPathRoot = new AntFileSetPathRoot(fileSetArray);
            ClassFilter classFilter = this.collectClassFilters(antFileSetPathRoot);
            BloatClassEdit bloatClassEdit = this.collectClassEdits(classFilter);
            String[] stringArray = this.collectClassPath();
            this.enhanceClassFiles(antFileSetPathRoot, bloatClassEdit, stringArray);
            this.enhanceJars(bloatClassEdit, stringArray);
        }
        catch (Exception exception) {
            throw new BuildException((Throwable)exception);
        }
    }

    private String[] collectClassPath() throws Exception {
        Path path;
        final ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this._classPath.iterator();
        while (iterator.hasNext()) {
            path = (Path)iterator.next();
            String[] stringArray = path.list();
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
        }
        this.forEachResource(this._jars, new FileResourceBlock(){

            public void process(FileResource fileResource) throws Exception {
                arrayList.add(fileResource.getFile().getCanonicalPath());
            }
        });
        iterator = this._sources.iterator();
        while (iterator.hasNext()) {
            path = (FileSet)iterator.next();
            arrayList.add(path.getDir().getCanonicalPath());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private void enhanceClassFiles(AntFileSetPathRoot antFileSetPathRoot, BloatClassEdit bloatClassEdit, String[] stringArray) throws Exception {
        new Db4oFileInstrumentor(bloatClassEdit).enhance(antFileSetPathRoot, this._targetDir, stringArray);
    }

    private void enhanceJars(BloatClassEdit bloatClassEdit, final String[] stringArray) throws Exception {
        final Db4oJarEnhancer db4oJarEnhancer = new Db4oJarEnhancer(bloatClassEdit);
        this.forEachResource(this._jars, new FileResourceBlock(){

            public void process(FileResource fileResource) throws Exception {
                File file = new File(Db4oFileEnhancerAntTask.this._jarTargetDir, fileResource.getFile().getName());
                db4oJarEnhancer.enhance(fileResource.getFile(), file, stringArray);
            }
        });
    }

    private ClassFilter collectClassFilters(AntFileSetPathRoot antFileSetPathRoot) throws Exception {
        final ArrayList<AntFileSetPathRoot> arrayList = new ArrayList<AntFileSetPathRoot>();
        arrayList.add(antFileSetPathRoot);
        this.forEachResource(this._jars, new FileResourceBlock(){

            public void process(FileResource fileResource) throws IOException {
                JarFile jarFile = new JarFile(fileResource.getFile());
                arrayList.add(new JarFileClassFilter(jarFile));
            }
        });
        CompositeOrClassFilter compositeOrClassFilter = new CompositeOrClassFilter(arrayList.toArray(new ClassFilter[arrayList.size()]));
        return compositeOrClassFilter;
    }

    private void forEachResource(List list, FileResourceBlock fileResourceBlock) throws Exception {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            FileSet fileSet = (FileSet)iterator.next();
            Iterator iterator2 = fileSet.iterator();
            while (iterator2.hasNext()) {
                FileResource fileResource = (FileResource)iterator2.next();
                fileResourceBlock.process(fileResource);
            }
        }
    }

    private BloatClassEdit collectClassEdits(ClassFilter classFilter) {
        BloatClassEdit bloatClassEdit = null;
        switch (this._editFactories.size()) {
            case 0: {
                bloatClassEdit = new NullClassEdit();
                break;
            }
            case 1: {
                bloatClassEdit = ((AntClassEditFactory)this._editFactories.get(0)).createEdit(classFilter);
                break;
            }
            default: {
                ArrayList<BloatClassEdit> arrayList = new ArrayList<BloatClassEdit>(this._editFactories.size());
                Iterator iterator = this._editFactories.iterator();
                while (iterator.hasNext()) {
                    AntClassEditFactory antClassEditFactory = (AntClassEditFactory)iterator.next();
                    arrayList.add(antClassEditFactory.createEdit(classFilter));
                }
                bloatClassEdit = new CompositeBloatClassEdit(arrayList.toArray(new BloatClassEdit[arrayList.size()]), true);
            }
        }
        return bloatClassEdit;
    }

    private static interface FileResourceBlock {
        public void process(FileResource var1) throws Exception;
    }
}

