/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.instrumentation.ant;

import com.db4o.instrumentation.ant.AntJarEntryInstrumentationClassSource;
import com.db4o.instrumentation.core.ClassFilter;
import com.db4o.instrumentation.file.FileInstrumentationClassSource;
import com.db4o.instrumentation.file.FilePathRoot;
import com.db4o.instrumentation.util.BloatUtil;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ZipFileSet;
import org.apache.tools.ant.types.resources.FileResource;

class AntFileSetPathRoot
implements FilePathRoot,
ClassFilter {
    private FileSet[] _fileSets;
    private DirectoryScanner[] _scanners;

    public AntFileSetPathRoot(FileSet[] fileSetArray) {
        this._fileSets = fileSetArray;
        this._scanners = new DirectoryScanner[this._fileSets.length];
        for (int i = 0; i < this._fileSets.length; ++i) {
            DirectoryScanner directoryScanner = this._fileSets[i].getDirectoryScanner();
            directoryScanner.scan();
            this._scanners[i] = directoryScanner;
        }
    }

    public Iterator files() {
        return new FileSetIterator(this._fileSets);
    }

    public String[] rootDirs() throws IOException {
        String[] stringArray = new String[this._fileSets.length];
        for (int i = 0; i < this._fileSets.length; ++i) {
            FileSet fileSet = this._fileSets[i];
            File file = fileSet.getDir();
            if (file == null && fileSet instanceof ZipFileSet) {
                ZipFileSet zipFileSet = (ZipFileSet)fileSet;
                file = zipFileSet.getSrc();
            }
            if (file == null) {
                file = File.listRoots()[0];
            }
            stringArray[i] = file.getCanonicalPath();
        }
        return stringArray;
    }

    public boolean accept(Class clazz) {
        for (int i = 0; i < this._scanners.length; ++i) {
            DirectoryScanner directoryScanner = this._scanners[i];
            String[] stringArray = directoryScanner.getIncludedFiles();
            for (int j = 0; j < stringArray.length; ++j) {
                String string = stringArray[j];
                String string2 = BloatUtil.classNameForPath(string);
                if (!clazz.getName().equals(string2)) continue;
                return true;
            }
        }
        return false;
    }

    private static class FileSetIterator
    implements Iterator {
        private final FileSet[] _fileSets;
        private int _fileSetIdx;
        private Iterator _fileSetIter;

        public FileSetIterator(FileSet[] fileSetArray) {
            this._fileSets = fileSetArray;
            this.advanceFileSet();
        }

        public boolean hasNext() {
            return this._fileSetIter.hasNext();
        }

        public Object next() {
            Resource resource = (Resource)this._fileSetIter.next();
            this.advanceFileSet();
            if (resource instanceof FileResource) {
                FileResource fileResource = (FileResource)resource;
                return new FileInstrumentationClassSource(fileResource.getBaseDir(), fileResource.getFile());
            }
            return new AntJarEntryInstrumentationClassSource(resource);
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void advanceFileSet() {
            while (!(this._fileSetIter != null && this._fileSetIter.hasNext() || this._fileSetIdx >= this._fileSets.length)) {
                this._fileSetIter = this._fileSets[this._fileSetIdx].iterator();
                ++this._fileSetIdx;
            }
        }
    }
}

