#include "headers/window.h"

Window::Window (QString title, int width, int height) {
	this->setWindowTitle(title);
	this->setMinimumSize(QSize(width, height));
	this->setMaximumSize(QSize(width, height));
	
    this->timer = new QTimer(this);
    this->connect(this->timer, SIGNAL(timeout()), this, SLOT(update()));
    timer->start(100);
	
	this->drawer = NULL;
	this->funcTimer = NULL;
	this->funcKey = NULL;
}

void Window::setDrawer (Drawer* d) {
	this->drawer = d;
	this->drawer->setDevice(this);
}

void Window::paintEvent(QPaintEvent*) {
	if (this->funcTimer != NULL)
		this->funcTimer();
	if (this->drawer != NULL)
		this->drawer->draw();
}

void Window::setTimerCall (timerCall tc) {
	this->funcTimer = tc;
}

void Window::setKeyDown (keyDown kd) {
	this->funcKey = kd;
}

void Window::keyPressEvent(QKeyEvent *event) {
	if (this->funcKey != NULL)
		this->funcKey(event);
}
