#include "headers/maze.h"
#include <QFile>
#include <QFileInfo>
#include <QTextStream>

void Maze::load (QString filename) {
	QFile file(filename);
	if (!file.open(QIODevice::ReadOnly | QIODevice::Text))
		throw QString("No se ha encontrado el fichero del laberinto en:\n").append(QFileInfo(file).absoluteFilePath());
	
	QTextStream in(&file);
	int row = 0, tmp;
	QString line;
	while (!in.atEnd()) {
		line = in.readLine();
		if (row == 0)
			this->width = line.size();
		else if (this->width != line.size())
			throw file.fileName().append(QString(" mal formado."));
		
		tmp = line.indexOf('3');
		if (tmp >= 0)
			this->goal = QPoint(tmp, row);
		tmp = line.indexOf('2');
		if (tmp >= 0)
			this->start = QPoint(tmp, row);
		
		QList<int> tmp;
		for (int i=0; i<line.size(); i++)
			tmp.append(QString(line[i]).toInt());
		this->map.append(tmp);
		
		row++;
	}
	this->height = row;
	
	file.close();
}

QList< QList<int> >* Maze::getMazeInfo () {
	return &this->map;
}

QPoint* Maze::getGoal() {
	return &this->goal;
}

QPoint* Maze::getStart() {
	return &this->start;
}

int Maze::getWidth() {
	return this->width;
}

int Maze::getHeight() {
	return this->height;
}

bool Maze::inBounds (QPoint p) {
	if ((p.rx() >= this->getWidth()) || 
			(p.rx() < 0) || 
			(p.ry() >= this->getHeight()) || 
			(p.ry() < 0))
		return false;
	return true;
}

bool Maze::ocuped (QPoint p) {
	return (this->map[p.ry()][p.rx()] == 1);
}

bool Maze::feasible (QPoint p) {
	return ((this->inBounds(p)) && (!this->ocuped(p)));  
}
