#include <QApplication>
#include <QMessageBox>
#include <QKeyEvent>
#include "headers/maze.h"
#include "headers/window.h"
#include "headers/bobdrawer.h"

Window* w;
Bob* bob;
Maze* maze;

void funcTime () {
	if (bob->move()) {
		QMessageBox::information(w, "Camino encontrado", QString("El camino ha sido encontrado en la generacion ").append(QString::number(bob->getGeneration())));
	}
}

void funcKey (QKeyEvent* qke) {
	if (qke->key() == Qt::Key_Space)
		bob->start();
	else if (qke->key() == Qt::Key_Enter)
		bob->pause();
}

int main(int argc, char *argv[]) {
    QApplication a(argc, argv);
    a.connect(&a, SIGNAL(lastWindowClosed()), &a, SLOT(quit()));

    try {
    	maze = new Maze();
    	maze->load("maze.txt");
	    w = new Window (QString("Bob's Maze"), 500, 300);
	    w->setTimerCall(&funcTime);
	    w->setKeyDown(&funcKey);
	    bob = new Bob(maze, GenData(0.7, 0.001, 70, 140));
	    w->show();
	    w->setDrawer(new BobDrawer(bob, maze));
    } catch (QString s) {
    	QMessageBox::critical(w, "Error", s);
    }
    a.exec();
}
