#ifndef GENOMA_H
#define GENOMA_H

#include "utils.h"
#include "utils.h"
#include <QPoint>
#include <QList>

class Genoma {
private:
	double fitness;
	QList<int> chromosomas;
	QList<QPoint> path;
public:
	Genoma();
	Genoma(int);
	double getFitness ();
	QList<QPoint>* getPath();
	QList<int> getValues ();
	void mutate (double mutation_rate);
	void crossover (Genoma* secondParent, double crossover_rate, Genoma* firstSon, Genoma* secondSon);
	void setFitness(double);
};

#endif
