#ifndef BOB_H
#define BOB_H

#include "maze.h"
#include "genoma.h"
#include <QList>

typedef struct GenData {
	double crossoverRate;
	double mutationRate;
	int populationSize;
	int cromoLenght;
	GenData() {}
	GenData (double crossRate, double mutRate, int popSize, int cromLenght) :
		crossoverRate(crossRate), mutationRate (mutRate), populationSize(popSize), cromoLenght (cromLenght) {}
};

class Bob {
private:
	Maze* maze;
	bool inPause;
	
	GenData algorithmData;			// Datos necesarios para llevar a cabo el algoritmo
	void createFirstGeneration ();
	void makeGeneration ();			// Crea una generación
	void updateFitness ();
	void testRoute (Genoma*);
	int rouleteSelection ();
	double getTotalFitness ();
	
	QList<Genoma> population;
	int fittestGenoma;
	double bestFitness;
	int generation;
public:
	Bob(Maze*, GenData);
	bool move ();
	void start ();
	void pause ();
	QList<QPoint>* currentRoute ();
	int getGeneration ();
};

#endif
