#include "headers/genoma.h"
#include <QMessageBox>


Genoma::Genoma () {
	this->fitness = 0;	
}

Genoma::Genoma (int nCromo) {
	this->fitness = 0;
	for (int i=0; i<nCromo; i++)
		this->chromosomas.push_back(randInt(0, 1)); 
}

QList<int> Genoma::getValues () {
	QList<int> values;
	for (int i=chromosomas.size() - 1; i>= 0; i-=2) 
		values.push_back ((chromosomas[i] * 2) + chromosomas[i - 1]);
	return values;
}

void Genoma::crossover (Genoma* secondParent, double crossover_rate, Genoma* firstSon, Genoma* secondSon) {
	if (randFloat() > crossover_rate) {
		firstSon->chromosomas = this->chromosomas;
		secondSon->chromosomas = secondParent->chromosomas;
		return;
	}

	int corte = randInt(0, this->chromosomas.size() - 1);
	for (int i=0; i<corte; i++) {
		firstSon->chromosomas.push_back(this->chromosomas[i]);
		secondSon->chromosomas.push_back(secondParent->chromosomas[i]);
	}
	for (int i=corte; i<this->chromosomas.size(); i++) {
		firstSon->chromosomas.push_back(secondParent->chromosomas[i]);
		secondSon->chromosomas.push_back(firstSon->chromosomas[i]);
	}
}

void Genoma::mutate (double mutation_rate) {
	for (int i=0; i< this->chromosomas.size(); i++) 
		if (randFloat() < mutation_rate) 
			this->chromosomas[i] = !this->chromosomas[i];
}

QList<QPoint>* Genoma::getPath() {
	return &this->path;
}

double Genoma::getFitness () {
	return this->fitness;
}

void Genoma::setFitness(double f) {
	this->fitness = f;
}
