#include "headers/bobdrawer.h"

BobDrawer::BobDrawer(Bob* b, Maze* m) {
	this->bob = b;
	this->maze = m;
}

void BobDrawer::draw() {
	QPainter p;
	int tmpX = this->maze->getWidth() + 2;
	int tmpY = this->maze->getHeight() + 2;
	int tmpW = this->device->width() / tmpX;
	int tmpH = this->device->height() / tmpY;

	p.begin(this->device);
	p.setPen(QPen(QColor("black"), 2));

	for (int i=0; i<this->maze->getMazeInfo()->size(); i++) {
		QList<int> lista = this->maze->getMazeInfo()->at(i);
		for (int k=0; k<lista.size(); k++) {
			switch (lista.at(k)) {
			case 0: p.setBrush(QColor("white")); break;
			case 1: p.setBrush(QColor("gray")); break;
			case 2: p.setBrush(QColor("blue")); break;
			case 3: p.setBrush(QColor("red")); break;
			case 4: p.setBrush(QColor("white")); break;
			}
			
			p.drawRect(tmpW * (k + 1), tmpH * (i + 1), tmpW, tmpH);
		}
	}
	if (bob->getGeneration() != -1) {
		QList<QPoint> path = *this->bob->currentRoute();
		p.setBrush(QColor("yellow"));
		for (unsigned int i=0; i<path.size(); i++) 
			p.drawRect(tmpW * (path[i].rx() + 1), tmpH * (path[i].ry() + 1), tmpW, tmpH);
	}
	p.end();
}
