#include "headers/bob.h"

Bob::Bob (Maze* m, GenData gd) {
	this->maze = m;
	this->inPause = true;
	this->algorithmData = gd;
	this->generation = -1;
}

bool Bob::move () {
	if ((this->inPause) || (this->bestFitness == 1))
		return false;
	
	this->makeGeneration();
	return (this->bestFitness == 1);
}

void Bob::start() {
	srand( (unsigned)time( NULL ) );
	this->inPause = false;
	
	this->fittestGenoma = 0;
	this->bestFitness = 0;
	
	this->population.clear();
	this->createFirstGeneration ();
}

void Bob::pause () {
	this->inPause = !this->inPause;
}

void Bob::createFirstGeneration () {
	this->generation = 0;
	for (int i=0; i<this->algorithmData.populationSize; i++) {
		Genoma g(this->algorithmData.cromoLenght);
		this->testRoute(&g);
		this->population.push_back(g);
	}
}

void Bob::makeGeneration() {
	this->updateFitness();

	QList<Genoma> babies;

	while (babies.size() < this->algorithmData.populationSize) {
		Genoma dad = this->population[this->rouleteSelection()];
		Genoma mum = this->population[this->rouleteSelection()];
		Genoma babie1;
		Genoma babie2;

		dad.crossover(&mum, this->algorithmData.crossoverRate, &babie1, &babie2);

		babie1.mutate(this->algorithmData.mutationRate);
		babie2.mutate(this->algorithmData.mutationRate);
		
		this->testRoute(&babie1);
		this->testRoute(&babie2);
		
		babies.push_back(babie1);
		babies.push_back(babie2);
	}

	this->population = babies;
	this->generation++;
}

void Bob::testRoute(Genoma* g) {
	QPoint pos = (*this->maze->getStart());
	QPoint pTmp;
	QList<int> values = g->getValues();
	for (int i=0; i<this->algorithmData.cromoLenght; i++) {
		pTmp = pos;
		switch(values[i]) {
		case 0: pTmp.setY(pTmp.ry() - 1); break;
		case 1: pTmp.setY(pTmp.ry() + 1); break;
		case 2: pTmp.setX(pTmp.rx() + 1); break;
		case 3: pTmp.setX(pTmp.rx() - 1); break;
		}
		if (this->maze->feasible(pTmp)) {
			pos = pTmp;
			g->getPath()->push_back(pos);
			if ((this->maze->getGoal()->rx() == pTmp.rx()) && (this->maze->getGoal()->ry() == pTmp.ry())) {
				g->setFitness(1);
				return;
			}
		}
	}
	int	DiffX = abs(pos.rx() - this->maze->getGoal()->rx());
	int DiffY = abs(pos.ry() - this->maze->getGoal()->ry());
	
	g->setFitness(1/(double)(DiffX+DiffY+1));
}

void Bob::updateFitness () {
	double tmp;
	for (int i=0; i<this->algorithmData.populationSize; i++) {
		tmp = this->population[i].getFitness();
		if (tmp > this->bestFitness) {
			this->fittestGenoma = i;
			this->bestFitness = tmp;
		}
	}
}

QList<QPoint>* Bob::currentRoute () {
	return this->population[this->fittestGenoma].getPath();
}

int Bob::getGeneration () {
	return this->generation;
}

double Bob::getTotalFitness () {
	double total = 0;
	for (int i=0; i<this->algorithmData.populationSize; i++)
		total += this->population[i].getFitness();
	return total;
}

int Bob::rouleteSelection () {
	double porcion = this->getTotalFitness() * randFloat();
	double tmp = 0;
	int idx = 0;
	while (tmp < porcion) {
		tmp += this->population[idx].getFitness();
		idx++;
	}
	return idx - 1;
}

