#include <iostream>
#include <sstream>
#include <string>
#include <vector>
#include <math.h>

using namespace std;

template <typename K>
int search (vector<K> v, K x) {
	for (unsigned int i=0; i<v.size(); i++)
		if (v[i] == x)
			return i;
	return -1;
}

vector<int> strToVector (string s) {
	vector<int> v;
	char tmp;
	for (unsigned int i=0; i<s.size(); i++) {
		tmp = s.at(i);
		v.push_back(atoi(&tmp));
	}
	return v;
}

template <typename K>
vector<K> swap (vector<K> v, unsigned int x, unsigned int y) {
	vector<K> w;
	for (unsigned int i=0; i<v.size(); i++)
		if (i == x)
			w.push_back(v[y]);
		else if (i == y)
			w.push_back(v[x]);
		else
			w.push_back(v[i]);
	return w;
}

class Puzzle {
protected:
	Puzzle () {}
	vector<int> piezas;
public:
	Puzzle (vector<int> v) : piezas(v) {}
	
	vector<int> getPiezas() {
		return this->piezas;
	}
	
	bool correct (vector<int> p) {
		for (int i=0; i<9; i++) 
			if (search<int>(p, i) == -1)
				return false;
		return (p.size() == 9);
	}
	
	bool correct () {
		return this->correct(this->piezas);
	}
	
	string getString () {
		ostringstream myStream;
		for (unsigned int i=0; i<piezas.size(); i++) {
			if (piezas[i] == 0)
				myStream << "  " << flush;
			else
				myStream << piezas[i] << " " << flush;
			if ((i + 1) % 3 == 0)
				myStream << "\n";
		}
		myStream << "\n";
		return myStream.str();
	}
	
	vector<Puzzle> getPosibles () {
		vector<Puzzle> puzzleTmp;
		vector<int> tmp;
		int posZero = search(this->piezas, 0);
		if (posZero > 2) {  
			tmp = swap<int>(this->piezas, posZero, (((posZero / 3) - 1) * 3) + (posZero % 3));
			puzzleTmp.push_back(Puzzle(tmp));
		}
		if (posZero % 3 != 0) {
			tmp = swap<int>(this->piezas, posZero, posZero - 1);
			puzzleTmp.push_back(Puzzle(tmp));
		}
		if (posZero % 3 != 2) {
			tmp = swap<int>(this->piezas, posZero, posZero + 1);
			puzzleTmp.push_back(Puzzle(tmp));
		}
		if (posZero < 7) {  
			tmp = swap<int>(this->piezas, posZero, (((posZero / 3) + 1) * 3) + (posZero % 3));
			puzzleTmp.push_back(Puzzle(tmp));
		}
		return puzzleTmp;
	}
	
	bool operator == (Puzzle b) {
		for (unsigned int i=0; i<9; i++) 
			if (this->piezas[i] != b.piezas[i])
				return false;
		return true;
	}
	
	bool operator != (Puzzle b) {
		return !((*this) == b);
	}
	
	int getDistX (int num, Puzzle* pB) {
		int i = search(this->getPiezas(), num) % 3;
		int k = search(pB->getPiezas(), num) % 3;
		return abs(i - k);
	}
	
	int getDistY (int num, Puzzle* pB) {
		int i = search(this->getPiezas(), num) / 3;
		int k = search(pB->getPiezas(), num) / 3;
		return abs(i - k);
	}
	
	void write () {
		for (unsigned int i=0; i<this->piezas.size(); i++)
			cout << this->piezas[i];
		cout << "\n";
	}
};

class State : public Puzzle {
private:
	friend class StateFactory;
	State() {}
	State (vector<int> v, State* p, Puzzle* goal) {
		this->piezas = v;
		this->parent = p;
		if (p == NULL)
			g = 1;
		else
			g = p->g + 1;
		this->calculaH(goal);
	}
	
protected:
	State* parent;
	int g, h;
	
	void calculaH (Puzzle* goal) {
		h = 0;
		int tmp;
		int counter = 0;
		for (int i=0; i<9; i++) {
			tmp = this->getDistX(i, goal) + this->getDistY(i, goal);
			if (tmp != 0) {
				h += pow(2, tmp);
				counter ++;
			}
		}
		h *= counter;
	}
	
public:	
	State* getParent () {
		return this->parent;
	}
	
	int getG () {
		return this->g;
	}
	
	int getF () {
		return g + h;
	}
};

class StateFactory {
private:
	static vector<State*> states;
public:	
	static State* newState (vector<int> v, State* p, Puzzle* goal) {
		State* s = new State(v, p, goal);
		StateFactory::states.push_back(s);
		return s;
	}

	static void deleteStates () {
		for (unsigned int i=0; i<states.size(); i++)
			delete StateFactory::states[i];
		StateFactory::states.clear();
	}
	
	static unsigned int nStates () {
		return StateFactory::states.size();
	}
};

vector<State*> StateFactory::states;

void putOnOpenList (State* state, Puzzle* goal, vector<State*>* open) {
	vector<Puzzle> puzzles = state->getPosibles();
	for (unsigned int i=0; i<puzzles.size(); i++) {
		Puzzle p = puzzles[i]; 
		if ((state->getParent() == NULL) || (p != *(state->getParent()))) {
			State* s = StateFactory::newState(p.getPiezas(), state, goal);
			open->push_back(s);
		}
	}
}

void putOnCloseList (State* state, vector<State*>* open, vector<State*>* close) {
	int i = search(*open, state);
	open->erase(open->begin() + i);
	close->push_back(state);
}

State* getNextState (vector<State*>* open) {
	State* best = NULL;
	State* tmp = NULL;
	for (unsigned int i=0; i<open->size(); i++) {
		tmp = (*open)[i];
		if ((best == NULL) || (tmp->getF() < best->getF()))
			best = tmp;
	}
	return best;
}

State* do_AStar (State* state, Puzzle* goal, vector<State*>* open, vector<State*>* close) {
	putOnOpenList(state, goal, open);
	putOnCloseList(state, open, close);
	State* next = getNextState(open);
	if ((*next) == (*goal))
		return next;
	return do_AStar(next, goal, open, close);
}

void AStar (Puzzle* init, Puzzle* goal) {
	vector<State*> open;
	vector<State*> close;
	
	State* iState = StateFactory::newState(init->getPiezas(), NULL, goal);
	open.push_back(iState);

	State* s = do_AStar(iState, goal, &open, &close);
	vector<State*> solution;
	do {
		solution.push_back(s);
		s = s->getParent();
	} while (s != NULL);
	for (int i=solution.size() - 1; i >= 0; i--)
		cout << (*solution[i]).getString();
	
	cout << "Resuelto en " << solution.size() << " pasos." << endl;
	cout << "Habiendo encontrado " << StateFactory::nStates() << " estados hasta entonces." << endl;
	
	StateFactory::deleteStates();
}

int main() {
	Puzzle* p = NULL;
	Puzzle* f = NULL;
	do {
		delete p;
		cout << "Introduce el puzzle, números 0 a 9, seguidos y siendo el 0 el espacio en blanco: ";
		string str("876543210");
		//cin >> str;
		p = new Puzzle(strToVector(str));
	} while (!p->correct());
	
	do {
		delete f;
		cout << "Introduce el puzzle al cual deseas llegar, números 0 a 9, seguidos y siendo el 0 el espacio en blanco: ";
		string str("012345678");
		//cin >> str;
		f = new Puzzle(strToVector(str));
	} while (!f->correct());
	cout << "\n";
	AStar(p, f);
	return 0;
}
